<?php
include("datos_sistema.php"); // Conexión a la base de datos

// Datos de la pasarela Flow
$apiKey = "6FD1ADFC-AFB0-42F8-B492-54D75L946918";
$secretKey = "266e6cf864ff129a1cb91e75418dea337555a490";

// Datos del formulario
$id_habitacion = $_POST['id_habitacion_post'] ?? '';
$fecha_entrada = $_POST['fecha_entrada'] ?? '';
$fecha_salida = $_POST['fecha_salida'] ?? '';
$nombre_habitacion = $_POST['nombre_habitacion'] ?? '';
$cantidad_personas = $_POST['cantidad_personas'] ?? '';
$nombre = $_POST['nombre'] ?? '';
$telefono = $_POST['telefono'] ?? '';
$notas = $_POST['notas'] ?? '';
$email = $_POST['correo'] ?? '';
$montoPago = $_POST['monto_pago'] ?? '';
$ordenCompra = $_POST['orden_compra'] ?? '';

// Validar que los campos obligatorios no estén vacíos
if (empty($ordenCompra) || empty($montoPago) || empty($email)) {
    echo "Error: Faltan parámetros obligatorios.";
    exit;
}

// URL de la API Flow
$flowUrl = "https://sandbox.flow.cl/api/payment/create"; // Cambia a producción cuando esté listo

// Datos del pago
$paymentData = [
    "commerceOrder" => $ordenCompra,
    "subject" => "Pago de reserva - $nombre_habitacion",
    "currency" => "CLP",
    "amount" => (float) $montoPago, // Aseguramos que sea un número
    "email" => $email,
    "urlConfirmation" => "https://hostalriberasdelcruces.cl/php/confirmacion.php",
    "urlReturn" => "https://hostalriberasdelcruces.cl/php/registrar_reserva.php?client=flowexitoso",
    "optional" => json_encode([
        "id_habitacion" => $id_habitacion,
        "fecha_entrada" => $fecha_entrada,
        "fecha_salida" => $fecha_salida,
        "nombre_habitacion" => $nombre_habitacion,
        "cantidad_personas" => $cantidad_personas,
        "nombre" => $nombre,
        "telefono" => $telefono,
        "notas" => $notas,
        "correo1" => $email
    ])
];

// Crear firma
$paymentDataJson = json_encode($paymentData);
$signature = base64_encode(hash_hmac('sha256', $paymentDataJson, $secretKey, true));

// Configuración del encabezado de la solicitud
$headers = [
    "Content-Type: application/json",
    "apiKey: $apiKey",
    "Signature: $signature"
];

// Enviar solicitud a Flow
$ch = curl_init($flowUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $paymentDataJson);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

$response = curl_exec($ch);
$httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpStatus == 200) {
    $responseArray = json_decode($response, true);
    if (isset($responseArray['url'])) {
        // Redirigir al usuario al enlace de pago
        header("Location: " . $responseArray['url']);
        exit;
    } else {
        echo "Error al crear el pago: " . $responseArray['message'];
    }
} else {
    echo "Error en la comunicación con Flow: HTTP $httpStatus";
    echo "Detalles: $response";
}
?>
